################################################################################################
#
# Bell Busters
#
################################################################################################

################################################################# General ################################################################

scoreboard objectives add r dummy
scoreboard objectives add rc minecraft.used:minecraft.carrot_on_a_stick
scoreboard objectives add sneak minecraft.custom:minecraft.sneak_time
scoreboard objectives add talk minecraft.custom:minecraft.talked_to_villager
scoreboard objectives add walk minecraft.custom:minecraft.walk_one_cm
scoreboard objectives add sprint minecraft.custom:minecraft.sprint_one_cm
scoreboard objectives add crouch minecraft.custom:minecraft.crouch_one_cm
scoreboard objectives add jump minecraft.custom:minecraft.jump
scoreboard objectives add pick_used minecraft.used:minecraft.diamond_pickaxe
scoreboard objectives add x dummy
scoreboard objectives add y dummy
scoreboard objectives add z dummy
scoreboard objectives add dx dummy
scoreboard objectives add dz dummy
scoreboard objectives add dy dummy
scoreboard objectives add sp_timer dummy
scoreboard objectives add walk_timer dummy
scoreboard objectives add bb_health dummy
scoreboard objectives add ring_timer dummy
scoreboard objectives add launch_timer dummy
scoreboard objectives add lr dummy
scoreboard objectives add ring_cd dummy
scoreboard objectives add jump_timer dummy
scoreboard objectives add jump_cd dummy
scoreboard objectives add is_jumping dummy
scoreboard objectives add chest_is_walking dummy

#Idea Credit: https://old.reddit.com/r/Minecraft/comments/d4zw0f/law_and_behold_i_bring_forth_the_bell_buster/

tellraw @a[tag=!init_msg] ["",{"text":"\n\n\n==-=-- Bell Busters - ","color":"red","bold":true},{"text":"by McMakistein","color":"gold","bold":true},{"text":" --=-==","color":"red","bold":true},{"text":"\n                 [","color":"none","bold":false},{"text":"Video about this creation","color":"dark_green","clickEvent":{"action":"open_url","value":"https://youtu.be/GBfPAixwjPo"}},{"text":"]\n\n","color":"none"},{"text":"                       More of my work:\n","bold":true,"color":"none"},{"text":"                [","bold":false,"color":"none"},{"text":"Youtube","color":"red","bold":true,"clickEvent":{"action":"open_url","value":"https://www.youtube.com/user/McMakistein?sub_confirmation=1."},"hoverEvent":{"action":"show_text","value":{"text":"","extra":[{"text":"Subscribe for more commandblock creation like this!"}]}}},{"text":"] - [","color":"none","bold":false},{"text":"Twitter","color":"blue","bold":true,"clickEvent":{"action":"open_url","value":"https://twitter.com/MrMakistein"},"hoverEvent":{"action":"show_text","value":{"text":"","extra":[{"text":"Follow me on twitter for updates and sneakpeaks on new projects!"}]}}},{"text":"] - [","color":"none","bold":false},{"text":"Instagram","color":"gold","bold":true,"clickEvent":{"action":"open_url","value":"http://instagram.com/mrmakistein"},"hoverEvent":{"action":"show_text","value":{"text":"","extra":[{"text":"Follow me on Instagram if you want to know more about me as a person!"}]}}},{"text":"]","color":"none","bold":false}]
tag @a add init_msg

gamerule logAdminCommands false
gamerule commandBlockOutput false


################################################### Give #############################################

give @a[tag=give] minecraft:ghast_spawn_egg{display:{Name:"{\"text\":\"Bell Buster\",\"italic\":\"false\"}",Lore:["Rightclick to spawn."]},EntityTag:{id:"minecraft:armor_stand",Invisible:1,Marker:1,Tags:["sp1","sp"]},HideFlags:63}
tag @a remove give


############################################################ Bell Ring #####################################################

scoreboard players add @e[tag=bellbuster_as] ring_timer 0
scoreboard players add @e[tag=bellbuster_as,scores={ring_timer=1..}] ring_timer 1
scoreboard players set @e[tag=bellbuster_as,scores={ring_timer=5..}] ring_timer 0

scoreboard players add @e[tag=bellbuster_as] ring_cd 0
scoreboard players remove @e[tag=bellbuster_as,scores={ring_cd=1..}] ring_cd 1
scoreboard players set @e[tag=bellbuster_as,scores={ring_timer=1..}] ring_cd 200

execute as @a at @s run scoreboard players set @e[tag=bellbuster_as,distance=..3,scores={ring_cd=0}] ring_timer 1
execute as @e[tag=bellbuster_as,scores={ring_timer=2}] at @s run particle cloud ~ ~1.5 ~ 0 0 0 0.4 30
execute as @e[tag=bellbuster_as,scores={ring_timer=2}] at @s run particle note ~ ~1.5 ~ 1 1 1 0.1 5
execute as @e[tag=bellbuster_as,scores={ring_timer=2}] at @s run playsound minecraft:block.bell.use master @a
execute as @e[tag=bellbuster_as,scores={ring_timer=2}] at @s run playsound minecraft:entity.phantom.flap master @a
execute as @e[tag=bellbuster_as,scores={ring_timer=2}] at @s run execute as @a[distance=..5] at @s run summon armor_stand ~ ~0.1 ~ {Tags:["throw_dir","throw_dir_init"],Silent:1,Invisible:1}
execute as @e[tag=bellbuster_as,scores={ring_timer=2}] at @s run tag @a[distance=..5] add launched

scoreboard players set @e[tag=bellbuster_as,scores={ring_timer=2..,jump_timer=..5}] jump_timer 40

execute as @e[tag=throw_dir_init] at @s run tp @s ~ ~ ~ facing entity @e[tag=bellbuster_as,limit=1,sort=nearest]
execute as @e[tag=throw_dir_init] at @s run function bellbuster:launch
execute as @e[tag=throw_dir_init] at @s run tag @s remove throw_dir_init
execute as @e[tag=throw_dir] at @s run tp @p[tag=launched] ~ ~ ~
effect give @a[tag=launched] levitation 1 255 true

scoreboard players add @e[tag=throw_dir] launch_timer 1
scoreboard players add @e[tag=launched] lr 1
scoreboard players set @a[tag=!launched] lr 0
tag @a[tag=launched,scores={lr=80..}] remove launched

execute as @e[tag=throw_dir,nbt={OnGround:1b},scores={launch_timer=3..}] at @s run effect clear @a[tag=launched,distance=..1,limit=1,sort=nearest] levitation
execute as @e[tag=throw_dir,nbt={OnGround:1b},scores={launch_timer=3..}] at @s run tag @a[tag=launched,distance=..1,limit=1,sort=nearest] remove launched
execute as @e[tag=throw_dir,nbt={OnGround:1b},scores={launch_timer=3..}] at @s run kill @s

############################################################ Jump #####################################################

scoreboard players add @e[tag=bellbuster_as] jump_timer 0
scoreboard players add @e[tag=bellbuster_as,scores={jump_timer=1..}] jump_timer 1
scoreboard players set @e[tag=bellbuster_as,scores={jump_timer=200..}] jump_timer 0

execute as @e[tag=bellbuster_as,scores={jump_timer=2}] at @s run function bellbuster:jump

execute as @e[tag=bellbuster_ai,nbt={OnGround:1b}] at @s run execute as @e[tag=bellbuster_as,scores={jump_timer=10..},limit=1,sort=nearest,distance=..1] at @s run particle block minecraft:stone ~ ~0.2 ~ 1 0 1 0.1 20 force
execute as @e[tag=bellbuster_ai,nbt={OnGround:1b}] at @s run execute as @e[tag=bellbuster_as,scores={jump_timer=10..},limit=1,sort=nearest,distance=..1] at @s run particle block minecraft:dirt ~ ~0.2 ~ 2 0 2 0.1 10 force
execute as @e[tag=bellbuster_ai,nbt={OnGround:1b}] at @s run execute as @e[tag=bellbuster_as,scores={jump_timer=10..},limit=1,sort=nearest,distance=..1] at @s run effect give @a[distance=..2] instant_damage 1 2
execute as @e[tag=bellbuster_ai,nbt={OnGround:1b}] at @s run execute as @e[tag=bellbuster_as,scores={jump_timer=10..},limit=1,sort=nearest,distance=..1] at @s run effect give @a[distance=2.01..4] instant_damage 1 1
execute as @e[tag=bellbuster_ai,nbt={OnGround:1b}] at @s run execute as @e[tag=bellbuster_as,scores={jump_timer=10..},limit=1,sort=nearest,distance=..1] at @s run playsound minecraft:entity.generic.explode master @a
execute as @e[tag=bellbuster_ai,nbt={OnGround:1b}] at @s run scoreboard players set @e[tag=bellbuster_as,scores={jump_timer=10..},limit=1,sort=nearest,distance=..1] jump_timer 0


scoreboard players add @e[tag=bellbuster_ai] is_jumping 0
scoreboard players remove @e[tag=bellbuster_ai,scores={is_jumping=1..}] is_jumping 1
scoreboard players set @e[tag=bellbuster_ai,nbt={OnGround:0b},scores={is_jumping=1..}] is_jumping 3

scoreboard players add @e[tag=bellbuster_as] jump_cd 0
scoreboard players remove @e[tag=bellbuster_as,scores={jump_cd=1..}] jump_cd 1

execute as @a at @s run scoreboard players set @e[scores={jump_cd=0,jump_timer=0},tag=bellbuster_as,distance=6..9] jump_timer 1

############################################################ Spawn #####################################################

execute as @e[type=item,nbt={OnGround:1b,Item:{id:"minecraft:nether_star",Count:1b}}] at @s if block ~ ~-1 ~ smooth_stone if block ~ ~-2 ~ grindstone if block ~-1 ~-1 ~ bell if block ~1 ~-1 ~ bell if block ~ ~-1 ~1 creeper_wall_head align xyz run summon armor_stand ~0.5 ~-2 ~0.5 {Marker:1,Invisible:1,Tags:["sp1","sp"]}
execute as @e[type=item,nbt={OnGround:1b,Item:{id:"minecraft:nether_star",Count:1b}}] at @s if block ~ ~-1 ~ smooth_stone if block ~ ~-2 ~ grindstone if block ~-1 ~-1 ~ bell if block ~1 ~-1 ~ bell if block ~ ~-1 ~-1 creeper_wall_head align xyz run summon armor_stand ~0.5 ~-2 ~0.5 {Marker:1,Invisible:1,Tags:["sp2","sp"]}
execute as @e[type=item,nbt={OnGround:1b,Item:{id:"minecraft:nether_star",Count:1b}}] at @s if block ~ ~-1 ~ smooth_stone if block ~ ~-2 ~ grindstone if block ~ ~-1 ~1 bell if block ~ ~-1 ~-1 bell if block ~1 ~-1 ~ creeper_wall_head align xyz run summon armor_stand ~0.5 ~-2 ~0.5 {Marker:1,Invisible:1,Tags:["sp3","sp"]}
execute as @e[type=item,nbt={OnGround:1b,Item:{id:"minecraft:nether_star",Count:1b}}] at @s if block ~ ~-1 ~ smooth_stone if block ~ ~-2 ~ grindstone if block ~ ~-1 ~1 bell if block ~ ~-1 ~-1 bell if block ~-1 ~-1 ~ creeper_wall_head align xyz run summon armor_stand ~0.5 ~-2 ~0.5 {Marker:1,Invisible:1,Tags:["sp4","sp"]}


scoreboard players add @e[tag=sp] sp_timer 1
execute as @e[tag=sp,scores={sp_timer=1}] at @s run kill @e[type=item,nbt={OnGround:1b,Item:{id:"minecraft:nether_star",Count:1b}},limit=1,sort=nearest]
execute as @e[tag=sp,scores={sp_timer=5}] at @s run particle cloud ~ ~1 ~ 0.5 0.5 0.5 0.05 30 force
execute as @e[tag=sp,scores={sp_timer=5}] at @s run particle enchant ~ ~1 ~ 0.8 0.8 0.8 0.1 10 force

execute as @e[tag=sp1,scores={sp_timer=1}] at @s run summon armor_stand ~ ~-2 ~ {Tags:["bellbuster","bellbuster_as","sp_init"],NoGravity:1,Invisible:1,Marker:1,DisabledSlots:4144959,Rotation:[0f]}
execute as @e[tag=sp1,scores={sp_timer=1}] at @s run summon zombie ~ ~-2 ~ {Tags:["bellbuster","bellbuster_ai","sp_init","invis"],Silent:1,PersistenceRequired:1,ActiveEffects:[{Id:14b,Amplifier:1b,Duration:99999999,ShowParticles:0b}],Health:9999f,Attributes:[{Name:generic.maxHealth,Base:9999},{Name:generic.movementSpeed,Base:0.26}],NoAI:1,Rotation:[0f]}
execute as @e[tag=sp1,scores={sp_timer=7}] at @s run setblock ~1 ~1 ~ air
execute as @e[tag=sp1,scores={sp_timer=7}] at @s run setblock ~-1 ~1 ~ air
execute as @e[tag=sp1,scores={sp_timer=7}] at @s run setblock ~ ~1 ~1 air
execute as @e[tag=sp1,scores={sp_timer=7}] at @s run fill ~ ~ ~ ~ ~1 ~ air

execute as @e[tag=sp2,scores={sp_timer=1}] at @s run summon armor_stand ~ ~-2 ~ {Tags:["bellbuster","bellbuster_as","sp_init"],NoGravity:1,Invisible:1,Marker:1,DisabledSlots:4144959,Rotation:[180f]}
execute as @e[tag=sp2,scores={sp_timer=1}] at @s run summon zombie ~ ~-2 ~ {Tags:["bellbuster","bellbuster_ai","sp_init","invis"],Silent:1,PersistenceRequired:1,ActiveEffects:[{Id:14b,Amplifier:1b,Duration:99999999,ShowParticles:0b}],Health:9999f,Attributes:[{Name:generic.maxHealth,Base:9999},{Name:generic.movementSpeed,Base:0.26}],NoAI:1,Rotation:[180f]}
execute as @e[tag=sp2,scores={sp_timer=7}] at @s run setblock ~1 ~1 ~ air
execute as @e[tag=sp2,scores={sp_timer=7}] at @s run setblock ~-1 ~1 ~ air
execute as @e[tag=sp2,scores={sp_timer=7}] at @s run setblock ~ ~1 ~-1 air
execute as @e[tag=sp2,scores={sp_timer=7}] at @s run fill ~ ~ ~ ~ ~1 ~ air

execute as @e[tag=sp3,scores={sp_timer=1}] at @s run summon armor_stand ~ ~-2 ~ {Tags:["bellbuster","bellbuster_as","sp_init"],NoGravity:1,Invisible:1,Marker:1,DisabledSlots:4144959,Rotation:[-90f]}
execute as @e[tag=sp3,scores={sp_timer=1}] at @s run summon zombie ~ ~-2 ~ {Tags:["bellbuster","bellbuster_ai","sp_init","invis"],Silent:1,PersistenceRequired:1,ActiveEffects:[{Id:14b,Amplifier:1b,Duration:99999999,ShowParticles:0b}],Health:9999f,Attributes:[{Name:generic.maxHealth,Base:9999},{Name:generic.movementSpeed,Base:0.26}],NoAI:1,Rotation:[-90f]}
execute as @e[tag=sp3,scores={sp_timer=7}] at @s run setblock ~ ~1 ~1 air
execute as @e[tag=sp3,scores={sp_timer=7}] at @s run setblock ~ ~1 ~-1 air
execute as @e[tag=sp3,scores={sp_timer=7}] at @s run setblock ~1 ~1 ~ air
execute as @e[tag=sp3,scores={sp_timer=7}] at @s run fill ~ ~ ~ ~ ~1 ~ air

execute as @e[tag=sp4,scores={sp_timer=1}] at @s run summon armor_stand ~ ~-2 ~ {Tags:["bellbuster","bellbuster_as","sp_init"],NoGravity:1,Invisible:1,Marker:1,DisabledSlots:4144959,Rotation:[90f]}
execute as @e[tag=sp4,scores={sp_timer=1}] at @s run summon zombie ~ ~-2 ~ {Tags:["bellbuster","bellbuster_ai","sp_init","invis"],Silent:1,PersistenceRequired:1,ActiveEffects:[{Id:14b,Amplifier:1b,Duration:99999999,ShowParticles:0b}],Health:9999f,Attributes:[{Name:generic.maxHealth,Base:9999},{Name:generic.movementSpeed,Base:0.26}],NoAI:1,Rotation:[90f]}
execute as @e[tag=sp4,scores={sp_timer=7}] at @s run setblock ~ ~1 ~1 air
execute as @e[tag=sp4,scores={sp_timer=7}] at @s run setblock ~ ~1 ~-1 air
execute as @e[tag=sp4,scores={sp_timer=7}] at @s run setblock ~-1 ~1 ~ air
execute as @e[tag=sp4,scores={sp_timer=7}] at @s run fill ~ ~ ~ ~ ~1 ~ air

execute as @e[tag=sp,scores={sp_timer=1}] at @s run scoreboard players set @e[tag=bellbuster_as,limit=1,sort=nearest] ring_cd 200
execute as @e[tag=sp,scores={sp_timer=1}] at @s run scoreboard players set @e[tag=bellbuster_as,limit=1,sort=nearest] jump_cd 100

execute as @e[tag=sp,scores={sp_timer=7}] at @s run execute as @e[tag=bellbuster_as,limit=1,sort=nearest] at @s run data merge entity @s {ArmorItems:[{},{},{},{id:"minecraft:diamond_pickaxe",tag:{Unbreakable:1,Damage:1},Count:1}]}
execute as @e[tag=sp,scores={sp_timer=3}] at @s run execute as @e[tag=sp_init,distance=..3,limit=2,sort=nearest] at @s run tp @s ~ ~2 ~
execute as @e[tag=sp,scores={sp_timer=3}] at @s run tag @e[tag=sp_init,distance=..3,limit=2,sort=nearest] remove sp_init


execute as @e[tag=sp,scores={sp_timer=15}] at @s run execute as @e[tag=bellbuster_ai,limit=1,sort=nearest,distance=..2] at @s run data merge entity @s {NoAI:0}
kill @e[tag=sp,scores={sp_timer=15..}]


############################################################ General #####################################################

execute as @e[tag=bellbuster_ai] run data merge entity @s {Fire:-10s}
execute as @e[tag=bellbuster_ai] at @s run tp @e[tag=bellbuster_as,limit=1,sort=nearest,distance=..2] @s


############################################################ Walking Animation #####################################################

scoreboard players add @e[tag=bellbuster_as] walk_timer 1
scoreboard players set @e[tag=bellbuster_as,scores={walk_timer=16..}] walk_timer 0

scoreboard players set @e[tag=bellbuster_as] chest_is_walking 1
execute as @e[tag=bellbuster_ai,nbt={Motion:[0.0,0.0,0.0]}] at @s run scoreboard players set @e[tag=bellbuster_as,distance=..2,limit=1,sort=nearest] chest_is_walking 0

execute as @e[tag=bellbuster_as,scores={walk_timer=0,chest_is_walking=1}] at @s run data merge entity @s {ArmorItems:[{},{},{},{id:"minecraft:diamond_pickaxe",tag:{Unbreakable:1,Damage:1},Count:1}]}
execute as @e[tag=bellbuster_as,scores={walk_timer=3,chest_is_walking=1}] at @s run data merge entity @s {ArmorItems:[{},{},{},{id:"minecraft:diamond_pickaxe",tag:{Unbreakable:1,Damage:2},Count:1}]}
execute as @e[tag=bellbuster_as,scores={walk_timer=8,chest_is_walking=1}] at @s run data merge entity @s {ArmorItems:[{},{},{},{id:"minecraft:diamond_pickaxe",tag:{Unbreakable:1,Damage:1},Count:1}]}
execute as @e[tag=bellbuster_as,scores={walk_timer=11,chest_is_walking=1}] at @s run data merge entity @s {ArmorItems:[{},{},{},{id:"minecraft:diamond_pickaxe",tag:{Unbreakable:1,Damage:3},Count:1}]}
execute as @e[tag=bellbuster_as,scores={chest_is_walking=0}] at @s run data merge entity @s {ArmorItems:[{},{},{},{id:"minecraft:diamond_pickaxe",tag:{Unbreakable:1,Damage:1},Count:1}]}


############################################################ Death #####################################################

effect give @e[tag=bellbuster_ai] resistance 99 199 true
effect give @e[tag=invis] invisibility 9 9 true

scoreboard players add @e[tag=bellbuster_as] bb_health 0
execute as @e[tag=bellbuster_ai,nbt={HurtTime:9s},scores={is_jumping=0}] at @s run playsound minecraft:entity.creeper.hurt master @a
execute as @e[tag=bellbuster_ai,nbt={HurtTime:9s},scores={is_jumping=0}] at @s run scoreboard players add @e[tag=bellbuster_as,limit=1,sort=nearest,distance=..1] bb_health 1
execute as @e[tag=bellbuster_as,scores={bb_health=20..}] at @s run tag @s add kill

execute as @e[tag=bellbuster_as,tag=kill] at @s run execute as @e[tag=bellbuster_ai,limit=1,sort=nearest,distance=..2] at @s run data merge entity @s {DeathTime:19,Health:0}
execute as @e[tag=bellbuster_as,tag=kill] at @s run summon item ~ ~ ~0.05 {Item:{id:"minecraft:gunpowder",Count:64}}
execute as @e[tag=bellbuster_as,tag=kill] at @s run summon item ~ ~ ~0.05 {Item:{id:"minecraft:bell",Count:5}}
execute as @e[tag=bellbuster_as,tag=kill] at @s run summon item ~ ~ ~0.05 {Item:{id:"minecraft:diamond",Count:3}}
kill @e[tag=bellbuster_as,tag=kill]



tag @a remove give
scoreboard players set @a talk 0
scoreboard players set @a sneak 0
scoreboard players set @a jump 0
scoreboard players set @a rc 0
